# # Describing the changing positions of parties

library(RKernel)


library(magrittr)
library(memisc)



load("CHESwork.RData")


CHESwork %<>% within({
  ChristCons <- recode(partfam,
    "Confessional" <- 10,
    "Christian-Democratic" <- 4,
    "Conservative" <- 2,
    "Radical Right" <- 1,
    "Other" <- c(3,5:9,11),
  )
  YearF <- as.factor(CHESyear)
  Western.Europe <- country %in% c(1,2,3,5,6,7,8,10,11,12,13,14,16,38)
})


library(ggplot2)


cell.options(jupyter.plot.width=9.5,jupyter.plot.height=3)
ggplot(subset(CHESwork,Western.Europe)) + 
   geom_boxplot(aes(y=galtan,x=YearF,fill=ChristCons)) +
   theme_bw() +
   theme(legend.position = "none") +
   facet_wrap(~ChristCons,nrow=1) + labs(x="CHES Year",y="GAL/TAN")
ggsave("CHES-partfam-GALTAN-we-change-boxplot.pdf",width=9.5,height=3)  
ggsave("CHES-partfam-GALTAN-we-change-boxplot.png",width=9.5,height=3)  


cell.options(jupyter.plot.width=9.5,jupyter.plot.height=3)
ggplot(subset(CHESwork,Western.Europe)) + 
   geom_boxplot(aes(y=lrecon,x=YearF,fill=ChristCons)) +
   theme_bw() +
   theme(legend.position = "none") +
   facet_wrap(~ChristCons,nrow=1) + labs(x="CHES Year",y="Econ Left/Right")
ggsave("CHES-partfam-lrecon-we.pdf",width=9.5,height=3)  
ggsave("CHES-partfam-lrecon-we.png",width=9.5,height=3)  


cell.options(jupyter.plot.width=9,jupyter.plot.height=3)
ggplot(subset(CHESwork,Western.Europe & CHESyear > 2002)) + 
   geom_boxplot(aes(y=religious_principles,x=YearF,fill=ChristCons)) +
   theme_bw() +
   theme(legend.position = "none") +
   facet_wrap(~ChristCons,nrow=1) + labs(x="CHES Year",y="Religious principles")
ggsave("CHES-partfam-religprinc-we-change-boxplot.pdf",width=9,height=3)  
ggsave("CHES-partfam-religprinc-we-change-boxplot.png",width=9,height=3)     


cell.options(jupyter.plot.width=9,jupyter.plot.height=3)
ggplot(subset(CHESwork,Western.Europe & CHESyear > 2002)) + 
   geom_boxplot(aes(y=sociallifestyle,x=YearF,fill=ChristCons)) +
   theme_bw() +
   theme(legend.position = "none") +
   facet_wrap(~ChristCons,nrow=1) + labs(x="CHES Year",y="Social lifestyle")
ggsave("CHES-partfam-soclifestyle-we-change-boxplot.pdf",width=9,height=3)  
ggsave("CHES-partfam-soclifestyle-we-change-boxplot.png",width=9,height=3)        


cell.options(jupyter.plot.width=9,jupyter.plot.height=3)
ggplot(subset(CHESwork,Western.Europe & CHESyear > 2002)) + 
   geom_boxplot(aes(y=civlib_laworder,x=YearF,fill=ChristCons)) +
   theme_bw() +
   theme(legend.position = "none") +
   facet_wrap(~ChristCons,nrow=1) + labs(x="CHES Year",y="Law and Order")
ggsave("CHES-partfam-civlib_laworder-we-change-boxplot.pdf",width=9,height=3)  
ggsave("CHES-partfam-civlib_laworder-we-change-boxplot.png",width=9,height=3)        


cell.options(jupyter.plot.width=9,jupyter.plot.height=3)
ggplot(subset(CHESwork,Western.Europe & CHESyear > 2002)) + 
   geom_boxplot(aes(y=immigration,x=YearF,fill=ChristCons)) +
   theme_bw() +
   theme(legend.position = "none") +
   facet_wrap(~ChristCons,nrow=1) + labs(x="CHES Year",y="Immigration")
ggsave("CHES-partfam-immigration-we-change-boxplot.pdf",width=9,height=3)  
ggsave("CHES-partfam-immigration-we-change-boxplot.png",width=9,height=3)        




